#ifndef __MACRO_TYPE_DEFINE_H__
#define __MACRO_TYPE_DEFINE_H__

#include "math.h"

typedef struct _tagMacroIOPointerTable
{
	unsigned char * bit_buff_pointer;
	unsigned char * byte_buff_pointer;
	unsigned short * word_buff_pointer;
	unsigned int * dword_buff_pointer;
}
MACRO_IO_POINTER_TABLE;

typedef struct penparam
{
    short type;		
    short width;	
    int color;		
}PenParam;

typedef struct brushparam
{    
    int type;		
    int backColor;	
    int foreColor;	
}BrushParam;

typedef struct point
{    
    short x;
    short y;
}Point;

typedef int (*LocalOperFunc)( int regId, int regType, int addr, int nRegs, void *buf, int flag );
typedef int (*DrawRectFunc)( int x, int y, int w, int h, PenParam pen, BrushParam brh );
typedef int (*DrawRndRectFunc)( int x, int y, int w, int h, int radius, PenParam pen, BrushParam brh );
typedef int (*DrawEclipsFunc)( int x, int y, int w, int h, PenParam pen, BrushParam brh );
typedef int (*DrawLineFunc)( int x1, int y1, int x2, int y2, PenParam pen );
typedef int (*DrawPolygFunc)( Point pts[], int n, PenParam pen, BrushParam brh );
typedef int (*DrawArcFunc)( int x, int y, int w, int h, int start, int end, PenParam pen );
typedef int (*DrawPieFunc)( int x, int y, int w, int h, int start, int end, PenParam pen, BrushParam brh ); 
typedef int (*LoadSysParam)( int buf[] );//buf[0]-LCDɫ

typedef struct VOper{
 char marks[4];
 int flag;
 LocalOperFunc locRead;
 LocalOperFunc locWrite;
 
 DrawLineFunc drawLine;	
 DrawRectFunc drawRect;	
 DrawRndRectFunc drawRndRect;	
 DrawPolygFunc drawPolyg;	
 DrawEclipsFunc drawEclips;	     
 DrawArcFunc drawArc;		
 DrawPieFunc drawPie;	
 LoadSysParam loadSysPrm;	//ȡϵͳ 	   
}VOperInf;

#ifdef WIN32
__declspec( dllexport ) int macro_main(MACRO_IO_POINTER_TABLE, MACRO_IO_POINTER_TABLE , VOperInf);
#endif

char *trim1(const char *str)
{
 static char line[4096];
 const char *pbegin;
	                            char *p,*pend;
 int i;
 pbegin=str;
	                            while (*pbegin==' ')
 pbegin++;
 p=line;
	                            while (*p=*pbegin)
{
 if ((*p==' ')&&(*(p-1)!=' '))
			                      pend=p;
p++;pbegin++; 
}
	                           if (*(p-1)!=' ') pend=p;
 *pend=0;
return line;
 }
#define ReadLocal(x1,x2,x3,x4,x5)   (xReadLocal(OPERLOCAL, x1, x2, x3, x4 ,x5) )
int xReadLocal(VOperInf OPERLOCAL, const char *type, int addr, int nRegs, void *buf ,int flag)
{

int regid = 0 ;
 int regtype = 0;
char *ptemp = trim1(type);
								                    if(strcmp(ptemp,"LW")== 0)
{													 regid = 255;
													 regtype = 2;
}
													 else if(strcmp(ptemp,"LB") ==0)
 {
 regid = 254;
regtype =0 ;
 }
													 else if(strcmp(ptemp,"RW") ==0)
 {
													 regid = 253;
													 regtype = 2;
 }
else if(strcmp(ptemp,"RB") ==0)
 {
													 regid = 252;
													 regtype =0 ;
 }
													 else if(strcmp(ptemp,"RWI") ==0)
 {
													 regid = 251;
													 regtype = 2;
 }
													 else if(strcmp(ptemp,"RBI") ==0)
 {
													 regid = 250;
													 regtype =0 ;
 }
													 else if(strcmp(ptemp,"LW.B") ==0)
 {
													 regid = 249;
													 regtype =0 ;
 }
													 else if(strcmp(ptemp,"ERW0") ==0)
 {
													 regid = 248;
													 regtype =2 ;
 }
 else if(strcmp(ptemp,"ERW1") ==0)
 {
													 regid = 247;
													 regtype =2 ;
 }
													 else if(strcmp(ptemp,"ERW2") ==0)
 {
													 regid = 246;
													 regtype =2 ;
 } 
													 else if(strcmp(ptemp,"ERWI0") ==0)
 {
													 regid = 245;
													 regtype =2 ;
 } 
													 else if(strcmp(ptemp,"ERWI1") ==0)
 {
													 regid = 244;
													 regtype =2 ;
 }
else if(strcmp(ptemp,"ERWI2") ==0)
 {
													 regid = 243;
													 regtype =2 ;
 }
													 else if(strcmp(ptemp,"FRW") ==0)
 {
													 regid = 242;
													 regtype =2 ;
 }
													 else if(strcmp(ptemp,"FRB") ==0)
 {
													 regid = 241;
													 regtype =0 ;
 }
else if(strcmp(ptemp,"FRWI") ==0)
 {
													 regid = 240;
													 regtype =2 ;
 }
													 else if(strcmp(ptemp,"FRBI") ==0)
 {
													 regid = 239;
													 regtype =0 ;
 }
													 else 
 {
													 return 0;
 }
													 return  OPERLOCAL.locRead(regid,regtype,addr,nRegs,buf,flag);
}
#define WriteLocal(x1,x2,x3,x4,x5)   (xWriteLocal(OPERLOCAL, x1, x2, x3, x4 ,x5) )
int xWriteLocal( VOperInf OPERLOCAL,const char *type, int addr, int nRegs,  void *buf,int flag)
{
int regid = 0 ;
								   int regtype = 0;
								   char *ptemp = trim1(type);
								   if(strcmp(ptemp,"LW")== 0)
{								   regid = 255;
								   regtype = 2;
}
								   else if(strcmp(ptemp,"LB") ==0)
 {
								   regid = 254;
								   regtype =0 ;
 }
								   else if(strcmp(ptemp,"RW") ==0)
 {
								   regid = 253;
								   regtype = 2;
}
else if(strcmp(ptemp,"RB") ==0)
 {
								   regid = 252;
								   regtype =0 ;
 }
								   else if(strcmp(ptemp,"RWI") ==0)
 {
								   regid = 251;
								   regtype = 2;
 }
								   else if(strcmp(ptemp,"RBI") ==0)
 {
								   regid = 250;
								   regtype =0 ;
 }
								   else if(strcmp(ptemp,"LW.b") ==0)
 {
								   regid = 249;
								   regtype =0 ;
 }
								   else if(strcmp(ptemp,"ERW0") ==0)
{
								   regid = 248;
								   regtype =2 ;
 }
								   else if(strcmp(ptemp,"ERW1") ==0)
 {
								   regid = 247;
								   regtype =2 ;
 }
else if(strcmp(ptemp,"ERW2") ==0)
 {
								   regid = 246;
								   regtype =2 ;
 } 
								   else if(strcmp(ptemp,"ERWI0") ==0)
 {
								   regid = 245;
								   regtype =2 ;
 } 
								   else if(strcmp(ptemp,"ERWI1") ==0)
 {
								   regid = 244;
								   regtype =2 ;
 }  
								   else if(strcmp(ptemp,"ERWI2") ==0)
 {
								   regid = 243;
								   regtype =2 ;
 }
else if(strcmp(ptemp,"FRW") ==0)
 {
								   regid = 242;
								   regtype =2 ;
 }
								   else if(strcmp(ptemp,"FRB") ==0)
 {
								   regid = 241;
								   regtype =0 ;
 }
								   else if(strcmp(ptemp,"FRWI") ==0)
 {
								   regid = 240;
								   regtype =2 ;
 }
								   else if(strcmp(ptemp,"FRBI") ==0)
 {
								   regid = 239;
								   regtype =0 ;
 }
								   else 
 {
								   return 0;
 }
								   return  OPERLOCAL.locWrite(regid,regtype,addr,nRegs,buf,flag);
 }

//
#define PS_NULL																				0 
#define PS_SOLID																			1
#define PS_DASH 																			2
#define PS_DOT 																				3
#define PS_DASHDOT																		4
#define PS_DASHDOTDOT																	5

//ʿֵСֵ
#define PW_MAX																				8
#define PW_MIN																				1

//ˢ
//ͼ
#define BFS_NOBRUSH																		0
#define BFS_SOLID																			1
#define BFS_DENSE1																		2
#define BFS_DENSE2																		3
#define BFS_DENSE3																		4
#define BFS_DENSE4																		5
#define BFS_DENSE5																		6
#define BFS_DENSE6																		7
#define BFS_DENSE7																		8
#define BFS_DENSE8																		9
#define BFS_DENSE9																		10
#define BFS_DENSE10																		11
#define BFS_DENSE11																  	12
#define BFS_DENSE12															  		13
#define BFS_FDIAG1																		14
#define BFS_BDIAG1																		15
#define BFS_FDIAG2																		16
#define BFS_BDIAG2																		17
#define BFS_FDIAG3																		18
#define BFS_BDIAG3																		19
#define BFS_VER1																			20
#define BFS_HOR1																			21
#define BFS_VER2																			22
#define BFS_HOR2																			23
#define BFS_VER3																			24
#define BFS_HOR3																			25
#define BFS_DIAGCROSS																	26
#define BFS_CROSS																			27

//
#define BFS_GRADIENT_MASK															0x100
//ˮƽ
#define BFS_HORGRDT_FTTD															256		//½
#define BFS_HORGRDT_FDTT															257		//Ͻ
#define BFS_HORGRDT_FETC															258		//ӱԵĽ
#define BFS_HORGRDT_FCTE															259		//Ե
//ֱ
#define BFS_VERGRDT_FLTR															260		//ҽ
#define BFS_VERGRDT_FRTL															261		//󽥽
#define BFS_VERGRDT_FETC															262		//ӱԵĽ
#define BFS_VERGRDT_FCTE															263		//Ե
//бϣԽߣ
#define BFS_OUPGRDT_FLTTRD														264		//½
#define BFS_OUPGRDT_FRDTLT														265		//Ͻ
#define BFS_OUPGRDT_FETC															266		//ӱԵĽ
#define BFS_OUPGRDT_FCTE															267		//Ե
//б£Խߣ
#define BFS_ODWNGRDT_FRTTLD														268		//½
#define BFS_ODWNGRDT_FLDTRT														269		//Ͻ
#define BFS_ODWNGRDT_FETC															270		//ӱԵĽ
#define BFS_ODWNGRDT_FCTE															271		//Ե
//ǲ
#define BFS_CONGRDT_FLTTRD														272		//½
#define BFS_CONGRDT_FRTTLD														273		//½
#define BFS_CONGRDT_FRDTLT														274		//Ͻ
#define BFS_CONGRDT_FLDTRT														275		//Ͻ
//Ľ
#define BFS_CENGRDT_FETC															276		//ӱԵĽ
#define BFS_CENGRDT_FCTE															277		//Ե

#define POLYG_NUM_MIN																	1
//LCDɫ
#define LCD_COLOR_DEPRH08															8
#define LCD_COLOR_DEPRH16															16

//RGB24תRGB565
#define RGB565(r, g, b) ((((((r & 0xff) << 5) >> 8) << 11) | ((((g & 0xff) << 6) >> 8) << 5) | (((b & 0xff) << 5) >> 8)) & 0xffff)
//RGB24תint
#define RGB(r, g, b) ((((r & 0xff) << 16) | ((g & 0xff) << 8) | (b & 0xff)) & 0xffffff)

int RGBGray(int r, int g, int b)
{
	int gray = r * r + g * g + b * b;
	gray = ((int)sqrt(((double)gray / 3.0))) & 0xff;
	
	return RGB(gray, gray, gray);
}

//黭ʲ
void CheckPenParam(int nLCDColorDepth, PenParam *pPen)
{
	int r = (int)(pPen->color >> 16) & 0xff;
	int g = (int)(pPen->color >> 8) & 0xff;
	int b = (int)(pPen->color >> 0) & 0xff;
	
	if(pPen->type > PS_DASHDOTDOT)
		pPen->type = PS_DASHDOTDOT;
	else if(pPen->type < PS_NULL)
		pPen->type = PS_NULL;
	
	if(pPen->width > PW_MAX)
		pPen->width = PW_MAX;
	else if(pPen->width < PW_MIN)
		pPen->width = PW_MIN;
	
	if(nLCDColorDepth == LCD_COLOR_DEPRH08)
		pPen->color = RGBGray(r, g, b);
	else if(nLCDColorDepth == LCD_COLOR_DEPRH16)
		pPen->color = (int)RGB565(r, g, b);
}

//黭ˢ
void CheckBrushParam(int nLCDColorDepth, BrushParam *pBrush)
{
	int r = 0;
	unsigned int g = 0;
	unsigned int b = 0;
	
	if(pBrush->type & BFS_GRADIENT_MASK)
	{
		if(pBrush->type < BFS_HORGRDT_FTTD)
			pBrush->type = BFS_HORGRDT_FTTD;
		else if(pBrush->type > BFS_CENGRDT_FETC)
			pBrush->type = BFS_CENGRDT_FETC;
	}
	else
	{
		if(pBrush->type < BFS_NOBRUSH)
			pBrush->type = BFS_NOBRUSH;
		else if(pBrush->type > BFS_CROSS)
			pBrush->type = BFS_CROSS;
	}
	
	r = (pBrush->foreColor >> 16) & 0xff;
	g = (pBrush->foreColor >> 8) & 0xff;
	b = (pBrush->foreColor >> 0) & 0xff;
	if(nLCDColorDepth == LCD_COLOR_DEPRH08)
		pBrush->foreColor = (int)RGBGray(r, g, b);
	else if(nLCDColorDepth == LCD_COLOR_DEPRH16)
		pBrush->foreColor = (int)RGB565(r, g, b);
	
	r = (pBrush->backColor >> 16) & 0xff;
	g = (pBrush->backColor >> 8) & 0xff;
	b = (pBrush->backColor >> 0) & 0xff;
	if(nLCDColorDepth == LCD_COLOR_DEPRH08)
		pBrush->backColor = RGBGray(r, g, b);
	else if(nLCDColorDepth == LCD_COLOR_DEPRH16)
		pBrush->backColor = (int)RGB565(r, g, b);
}

//ͼ
#define DrawRect(x, y, w, h, pen, brh) DrawRectx(OPERLOCAL, x, y, w, h, pen, brh)
int DrawRectx(VOperInf OPERLOCAL, int x, int y, int w, int h, PenParam pen, BrushParam brh)
{
	int nLCDColorDepth;
	OPERLOCAL.loadSysPrm(&nLCDColorDepth);
	CheckPenParam(nLCDColorDepth, &pen);
	CheckBrushParam(nLCDColorDepth, &brh);
	
	return OPERLOCAL.drawRect(x, y, w, h, pen, brh);
}

#define DrawRndRect(x, y, w, h, radius, pen, brh) DrawRndRectx(OPERLOCAL, x, y, w, h, radius, pen, brh)
int DrawRndRectx(VOperInf OPERLOCAL, int x, int y, int w, int h, int radius, PenParam pen, BrushParam brh)
{
	int nLCDColorDepth;
	OPERLOCAL.loadSysPrm(&nLCDColorDepth);
	CheckPenParam(nLCDColorDepth, &pen);
	CheckBrushParam(nLCDColorDepth, &brh);
	
	return OPERLOCAL.drawRndRect(x, y, w, h, radius, pen, brh);
}

#define DrawEclips(x, y, w, h, pen, brh) DrawEclipsx(OPERLOCAL, x, y, w, h, pen, brh)
int DrawEclipsx(VOperInf OPERLOCAL, int x, int y, int w, int h, PenParam pen, BrushParam brh)
{
	int nLCDColorDepth;
	OPERLOCAL.loadSysPrm(&nLCDColorDepth);
	CheckPenParam(nLCDColorDepth, &pen);
	CheckBrushParam(nLCDColorDepth, &brh);
	
	return OPERLOCAL.drawEclips(x, y, w, h, pen, brh);
}

#define DrawLine(x1, y1, x2, y2, pen) DrawLinex(OPERLOCAL, x1, y1, x2, y2, pen)
int DrawLinex(VOperInf OPERLOCAL, int x1, int y1, int x2, int y2, PenParam pen)
{
	int nLCDColorDepth;
	OPERLOCAL.loadSysPrm(&nLCDColorDepth);
	CheckPenParam(nLCDColorDepth, &pen);
	
	return OPERLOCAL.drawLine(x1, y1, x2, y2, pen);
}

#define DrawPolyg(pts, n, pen, brh) DrawPolygx(OPERLOCAL, pts, n, pen, brh)
int DrawPolygx(VOperInf OPERLOCAL, Point pts[], int n, PenParam pen, BrushParam brh)
{
	int nLCDColorDepth;
	OPERLOCAL.loadSysPrm(&nLCDColorDepth);
	CheckPenParam(nLCDColorDepth, &pen);
	CheckBrushParam(nLCDColorDepth, &brh);
	
	if(n < POLYG_NUM_MIN)
		n = POLYG_NUM_MIN;
		
	return OPERLOCAL.drawPolyg(pts, n, pen, brh);
}

#define DrawArc(x, y, w, h, start, end, pen) DrawArcx(OPERLOCAL, x, y, w, h, start, end, pen)
int DrawArcx(VOperInf OPERLOCAL, int x, int y, int w, int h, int start, int end, PenParam pen)
{
	int nLCDColorDepth;
	OPERLOCAL.loadSysPrm(&nLCDColorDepth);
	CheckPenParam(nLCDColorDepth, &pen);
	
	return OPERLOCAL.drawArc(x, y, w, h, (360 - end), (360 - start), pen);
}

#define DrawPie(x, y, w, h, start, end, pen, brh) DrawPiex(OPERLOCAL, x, y, w, h, start, end, pen, brh)
int DrawPiex(VOperInf OPERLOCAL, int x, int y, int w, int h, int start, int end, PenParam pen, BrushParam brh)
{
	int nLCDColorDepth;
	OPERLOCAL.loadSysPrm(&nLCDColorDepth);
	CheckPenParam(nLCDColorDepth, &pen);
	CheckBrushParam(nLCDColorDepth, &brh);
	
	return OPERLOCAL.drawPie(x, y, w, h, (360 - end), (360 - start), pen, brh);
}
#endif // __MACRO_TYPE_DEFINE_H__

